/*-
 * Copyright (c) 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * William Jolitz.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	from: @(#)conf.c	5.8 (Berkeley) 5/12/91
 *	conf.c,v 1.17 1993/07/19 10:57:30 mycroft Exp
 */

#include "param.h"
#include "systm.h"
#include "buf.h"
#include "ioctl.h"
#include "tty.h"
#include "conf.h"

int	nullop(), enxio(), enodev(), rawread(), rawwrite(), swstrategy();
int	rawread(), rawwrite(), swstrategy();

#include "wd.h"
#if NWD > 0
int	wdopen(),wdclose(),wdstrategy(),wdioctl();
int	wddump(),wdsize();
#else
#define	wdopen		enxio
#define	wdclose		enxio
#define	wdstrategy	enxio
#define	wdioctl		enxio
#define	wddump		enxio
#define	wdsize		NULL
#endif

#include "sd.h"
#if NSD > 0
int	sdopen(),sdclose(),sdstrategy(),sdioctl();
int	/*sddump(),*/sdsize();
#define	sddump		enxio
#else
#define	sdopen		enxio
#define	sdclose		enxio
#define	sdstrategy	enxio
#define	sdioctl		enxio
#define	sddump		enxio
#define	sdsize		NULL
#endif

#include "st.h"
#if NST > 0
int	stopen(),stclose(),ststrategy(),stioctl();
/*int	stdump(),stsize();*/
#define	stdump		enxio
#define	stsize		NULL
#else
#define	stopen		enxio
#define	stclose		enxio
#define	ststrategy	enxio
#define	stioctl		enxio
#define	stdump		enxio
#define	stsize		NULL
#endif

#include "cd.h"
#if NCD > 0
int	cdopen(),cdclose(),cdstrategy(),cdioctl();
int	/*cddump(),*/cdsize();
#define	cddump		enxio
#else
#define	cdopen		enxio
#define	cdclose		enxio
#define	cdstrategy	enxio
#define	cdioctl		enxio
#define	cddump		enxio
#define	cdsize		NULL
#endif

#include "ch.h"
#if NCH > 0
int	chopen(),chclose(),chioctl();
#else
#define	chopen		enxio
#define	chclose		enxio
#define	chioctl		enxio
#endif

#include "wt.h"
#if NWT > 0
int	wtopen(),wtclose(),wtstrategy(),wtioctl();
int	wtdump(),wtsize();
#else
#define	wtopen		enxio
#define	wtclose		enxio
#define	wtstrategy	enxio
#define	wtioctl		enxio
#define	wtdump		enxio
#define	wtsize		NULL
#endif

#include "fd.h"
#if NFD > 0
int	Fdopen(),fdclose(),fdstrategy();
#define	fdioctl		enxio
#define	fddump		enxio
#define	fdsize		NULL
#else
#define	Fdopen		enxio
#define	fdclose		enxio
#define	fdstrategy	enxio
#define	fdioctl		enxio
#define	fddump		enxio
#define	fdsize		NULL
#endif

#ifdef LKM
int lkmopen(), lkmclose(), lkmioctl();	/* lkm interface routines */
int lkmenodev();                        /* lkm "nodev" routine */
#else
#define		lkmopen		enxio
#define		lkmclose	enxio
#define		lkmioctl	enxio
#define		lkmenodev	enodev
#endif
/* an easy way to define LKM devices */
#define LKM_BDEV \
	{ lkmenodev,    lkmenodev,      lkmenodev,      lkmenodev, \
	  lkmenodev,    lkmenodev,      NULL }, 
#define LKM_CDEV \
	{ lkmenodev,    lkmenodev,      lkmenodev,      lkmenodev, \
	  lkmenodev,    lkmenodev,      lkmenodev,      NULL, \
	  lkmenodev,    lkmenodev,      NULL },

int	swstrategy(),swread(),swwrite();

struct bdevsw	bdevsw[] =
{
	{ wdopen,	wdclose,	wdstrategy,	wdioctl,	/*0*/
	  wddump,	wdsize,		NULL },
	{ enodev,	enodev,		swstrategy,	enodev,		/*1*/
	  enodev,	enodev,		NULL },
	{ Fdopen,	fdclose,	fdstrategy,	fdioctl,	/*2*/
	  fddump,	fdsize,		NULL },
	{ wtopen,	wtclose,	wtstrategy,	wtioctl,	/*3*/
	  wtdump,	wtsize,		B_TAPE },
	{ sdopen,	sdclose,	sdstrategy,	sdioctl,	/*4*/
	  sddump,	sdsize,		NULL },
	{ stopen,	stclose,	ststrategy,	stioctl,	/*5*/
	  stdump,	stsize,		NULL },
	{ cdopen,	cdclose,	cdstrategy,	cdioctl,	/*6*/
	  cddump,	cdsize,		NULL },
LKM_BDEV								/*7*/
LKM_BDEV								/*8*/
LKM_BDEV								/*9*/
LKM_BDEV								/*10*/
LKM_BDEV								/*11*/
LKM_BDEV								/*12*/
/*
 * If you need a bdev major number, please contact the NetBSD team
 * by mailing netbsd-help@sun-lamp.cs.berkeley.edu.
 * If you assign one yourself it may conflict with someone else.
 */
};
int	nblkdev = sizeof (bdevsw) / sizeof (bdevsw[0]);

int	cnopen(),cnclose(),cnread(),cnwrite(),cnioctl(),cnselect();

int	cttyopen(), cttyread(), cttywrite(), cttyioctl(), cttyselect();

int 	mmrw();
#define	mmselect	seltrue

#include "pc.h"
#if NPC > 0
int	pcopen(),pcclose(),pcread(),pcwrite(),pcioctl(),pcmmap();
extern	struct tty *pc_tty[];
#else
#define pcopen		enxio
#define pcclose		enxio
#define pcread		enxio
#define pcwrite		enxio
#define pcioctl		enxio
#define	pcmmap		enxio
#define pc_tty		NULL
#endif

#include "pty.h"
#if NPTY > 0
int	ptsopen(),ptsclose(),ptsread(),ptswrite(),ptsstop();
int	ptcopen(),ptcclose(),ptcread(),ptcwrite(),ptcselect();
int	ptyioctl();
struct	tty *pt_tty[];
#else
#define ptsopen		enxio
#define ptsclose	enxio
#define ptsread		enxio
#define ptswrite	enxio
#define ptcopen		enxio
#define ptcclose	enxio
#define ptcread		enxio
#define ptcwrite	enxio
#define ptyioctl	enxio
#define	pt_tty		NULL
#define	ptcselect	enxio
#define	ptsstop		nullop
#endif

#include "com.h"
#if NCOM > 0
int	comopen(),comclose(),comread(),comwrite(),comioctl(),comselect();
#define comreset	enxio
extern	struct tty *com_tty[];
#else
#define comopen		enxio
#define comclose	enxio
#define comread		enxio
#define comwrite	enxio
#define comioctl	enxio
#define comreset	enxio
#define comselect	enxio
#define	com_tty		NULL
#endif

int	logopen(),logclose(),logread(),logioctl(),logselect();

int	ttselect(), seltrue();

#include "lpt.h"
#if NLPT > 0
int	lptopen(),lptclose(),lptwrite(),lptioctl();
#else
#define	lptopen		enxio
#define	lptclose	enxio
#define	lptwrite	enxio
#define	lptioctl	enxio
#endif

int	fdopen();

#include "bpfilter.h"
#if NBPFILTER > 0
int	bpfopen(),bpfclose(),bpfread(),bpfwrite(),bpfselect(),bpfioctl();
#else
#define	bpfopen		enxio
#define	bpfclose	enxio
#define	bpfread		enxio
#define	bpfwrite	enxio
#define	bpfselect	enxio
#define	bpfioctl	enxio
#endif

#include "dcfclk.h"
#if NDCFCLK > 0
int   dcfclkopen(),dcfclkclose(),dcfclkread(),dcfclkioctl(),dcfclkselect();
#else
#define dcfclkopen    enxio
#define dcfclkclose   enxio
#define dcfclkread    enxio
#define dcfclkioctl   enxio
#define dcfclkselect  enxio
#endif

#include "lpa.h"
#if NLPA > 0
int	lpaopen(),lpaclose(),lpawrite(),lpaioctl();
#else
#define lpaopen		enxio
#define lpaclose	enxio
#define lpawrite	enxio
#define lpaioctl	enxio
#endif

#ifdef ACCOUNTING
int	acctopen(),acctclose(),acctread(),acctwrite(),acctselect(),acctioctl();
#else
#define	acctopen	enxio
#define	acctclose	enxio
#define	acctread	enxio
#define	acctwrite	enxio
#define	acctselect	enxio
#define	acctioctl	enxio
#endif

#include "speaker.h"
#if NSPEAKER > 0
int     spkropen(),spkrclose(),spkrwrite(),spkrioctl();
#else
#define spkropen  enxio
#define spkrclose enxio
#define spkrwrite enxio
#define spkrioctl enxio
#endif

#include "mms.h"
#if NMMS > 0
int	mmsopen(), mmsclose(), mmsread(), mmsioctl(), mmsselect();
#else
#define mmsopen		enxio
#define mmsclose	enxio
#define mmsread		enxio
#define mmsioctl	enxio
#define mmsselect	enxio
#endif

#include "lms.h"
#if NLMS > 0
int	lmsopen(), lmsclose(), lmsread(), lmsioctl(), lmsselect();
#else
#define lmsopen		enxio
#define lmsclose	enxio
#define lmsread		enxio
#define lmsioctl	enxio
#define lmsselect	enxio
#endif

#include "pms.h"
#if NPMS > 0
int	pmsopen(), pmsclose(), pmsread(), pmsioctl(), pmsselect();
#else
#define pmsopen		enxio
#define pmsclose	enxio
#define pmsread		enxio
#define pmsioctl	enxio
#define pmsselect	enxio
#endif

struct cdevsw	cdevsw[] =
{
	{ cnopen,	cnclose,	cnread,		cnwrite,	/*0*/
	  cnioctl,	nullop,		nullop,		NULL,	/* console */
	  cnselect,	enodev,		NULL },
	{ cttyopen,	nullop,		cttyread,	cttywrite,	/*1*/
	  cttyioctl,	nullop,		nullop,		NULL,	/* tty */
	  cttyselect,	enodev,		NULL },
        { nullop,       nullop,         mmrw,           mmrw,           /*2*/
          enodev,       nullop,         nullop,         NULL,	/* memory */
          mmselect,     enodev,         NULL },
	{ wdopen,	wdclose,	rawread,	rawwrite,	/*3*/
	  wdioctl,	enodev,		nullop,		NULL,	/* wd */
	  seltrue,	enodev,		wdstrategy },
	{ nullop,	nullop,		rawread,	rawwrite,	/*4*/
	  enodev,	enodev,		nullop,		NULL,	/* swap */
	  enodev,	enodev,		swstrategy },
	{ ptsopen,	ptsclose,	ptsread,	ptswrite,	/*5*/
	  ptyioctl,	ptsstop,	nullop,		pt_tty,	/* ttyp */
	  ttselect,	enodev,		NULL },
	{ ptcopen,	ptcclose,	ptcread,	ptcwrite,	/*6*/
	  ptyioctl,	nullop,		nullop,		pt_tty,	/* ptyp */
	  ptcselect,	enodev,		NULL },
	{ logopen,	logclose,	logread,	enodev,		/*7*/
	  logioctl,	enodev,		nullop,		NULL,	/* klog */
	  logselect,	enodev,		NULL },
	{ comopen,	comclose,	comread,	comwrite,	/*8*/
	  comioctl,	enodev,		comreset,	com_tty, /* com */
	  comselect,	enodev,		NULL },
	{ Fdopen,	fdclose,	rawread,	rawwrite,	/*9*/
	  fdioctl,	enodev,		nullop,		NULL,	/* Fd (!=fd) */
	  seltrue,	enodev,		fdstrategy },
	{ wtopen,	wtclose,	rawread,	rawwrite,	/*10*/
	  wtioctl,	enodev,		nullop,		NULL,	/* wt */
	  seltrue,	enodev,		wtstrategy },
	{ enodev,	enodev,		enodev,		enodev,		/*11*/
	  enodev,	enodev,		nullop,		NULL,
	  seltrue,	enodev,		enodev },
	{ pcopen,	pcclose,	pcread,		pcwrite,	/*12*/
	  pcioctl,	nullop,		nullop,		pc_tty,	/* vga */
	  ttselect,	pcmmap,		NULL },
	{ sdopen,	sdclose,	rawread,	rawwrite,	/*13*/
	  sdioctl,	enodev,		nullop,		NULL,	/* sd */
	  seltrue,	enodev,		sdstrategy },
	{ stopen,	stclose,	rawread,	rawwrite,	/*14*/
	  stioctl,	enodev,		nullop,		NULL,	/* st */
	  seltrue,	enodev,		ststrategy },
	{ cdopen,	cdclose,	rawread,	enodev,		/*15*/
	  cdioctl,	enodev,		nullop,		NULL,	/* cd */
	  seltrue,	enodev,		cdstrategy },
	{ lptopen,	lptclose,	nullop,		lptwrite,	/*16*/
	  lptioctl,	nullop,		nullop,		NULL,	/* lpt */
	  seltrue,	enodev,		enodev},
	{ chopen,	chclose,	enxio,		enxio,		/*17*/
	  chioctl,	enxio,		enxio,		NULL,	/* ch */
	  enxio,	enxio,		enxio },
	{ enxio,	enxio,		enxio,		enxio,		/*18*/
	  enxio,	enxio,		enxio,		NULL,	/* scsi generic */
	  enxio,	enxio,		enxio },
	{ enxio,	enxio,		enxio,		enxio,		/*19*/
	  enxio,	enxio,		enxio,		NULL,	/* xten power ctrlr*/
	  enxio,	enxio,		enxio },
	{ enxio,	enxio,		enxio,		enxio,		/*20*/
	  enxio,	enxio,		enxio,		NULL,	/* soundblaster?*/
	  enxio,	enxio,		enxio },
	{ enxio,	enxio,		enxio,		enxio,		/*21*/
	  enxio,	enxio,		enxio,		NULL,	/* codrv */
	  enxio,	enxio,		enxio },
	{ fdopen,	enxio,		enxio,		enxio,		/*22*/
	  enxio,	enxio,		enxio,		NULL,	/* fd (!=Fd) */
	  enxio,	enxio,		enxio },
 	{ bpfopen,	bpfclose,	bpfread,	bpfwrite,	/*23*/
 	  bpfioctl,	enodev,		nullop,		NULL,	/* bpf */
 	  bpfselect,	enodev,		NULL },
	{ dcfclkopen,   dcfclkclose,    dcfclkread,     enodev,         /*24*/
	  dcfclkioctl,  enodev,         nullop,         NULL,   /* dcfclk */
	  dcfclkselect, enodev,         NULL },
	{ lpaopen,	lpaclose,	nullop,		lpawrite,	/*25*/
	  lpaioctl,	nullop,		nullop,		NULL,	/* lpa */
	  seltrue,	enodev,		enodev},
	{ acctopen,     acctclose,      acctread,       enodev,         /*26*/
	  acctioctl,    enodev,         nullop,         NULL,	/* acct */
	  acctselect,   enodev,         NULL },
	{ spkropen,     spkrclose,      enxio,          spkrwrite,      /*27*/
	  spkrioctl,    enxio,          enxio,          NULL,   /* spkr */
	  enxio,        enxio,          enxio },
	{ lkmopen,	lkmclose,	enodev,		enodev,         /*28*/
	  lkmioctl,	enodev,		nullop,		NULL,   /* lkm */
	  enodev,	enodev,		NULL },
LKM_CDEV								/*29*/
LKM_CDEV								/*30*/
LKM_CDEV								/*31*/
LKM_CDEV								/*32*/
LKM_CDEV								/*33*/
LKM_CDEV								/*34*/
	{ mmsopen,	mmsclose,	mmsread,	enodev,		/*35*/
	  mmsioctl,	enodev,		enodev,		NULL,	/* mms */
	  mmsselect,	enodev,		NULL },
	{ lmsopen,	lmsclose,	lmsread,	enodev,		/*36*/
	  lmsioctl,	enodev,		enodev,		NULL,	/* lms */
	  lmsselect,	enodev,		NULL },
	{ pmsopen,	pmsclose,	pmsread,	enodev,		/*37*/
	  pmsioctl,	enodev,		enodev,		NULL,	/* pms */
	  pmsselect,	enodev,		NULL },

/*
 * If you need a cdev major number, please contact the NetBSD team
 * by mailing netbsd-help@sun-lamp.cs.berkeley.edu.
 * If you assign one yourself it may then conflict with someone else.
 */
};
int	nchrdev = sizeof (cdevsw) / sizeof (cdevsw[0]);

int	mem_no = 2; 	/* major device number of memory special file */

/*
 * Swapdev is a fake device implemented
 * in sw.c used only internally to get to swstrategy.
 * It cannot be provided to the users, because the
 * swstrategy routine munches the b_dev and b_blkno entries
 * before calling the appropriate driver.  This would horribly
 * confuse, e.g. the hashing routines. Instead, /dev/drum is
 * provided as a character (raw) device.
 */
dev_t	swapdev = makedev(1, 0);
