/*
 * ioconf.c 
 * Generated by config program
 */

#include "machine/pte.h"
#include "sys/param.h"
#include "sys/buf.h"

#if __STDC__ > 0
#define VEC(s)	X##s
#else
#define VEC(s)	X/**/s
#endif
#define C (caddr_t)

/*
 * ISA devices
 */

#include "i386/isa/isa_device.h"
#include "i386/isa/isa.h"
#include "i386/isa/icu.h"

extern struct isa_driver wdcdriver; extern VEC(wdc0)();
extern struct isa_driver fdcdriver; extern VEC(fdc0)();
extern struct isa_driver  pcdriver; extern VEC(pc0)();
extern struct isa_driver npxdriver; extern VEC(npx0)();
extern struct isa_driver  nedriver; extern VEC(ne0)();

struct isa_device isa_devtab_bio[] = {
/*	driver	iobase	irq drq	maddr	msiz	intr unit	flags phys cnltr*/
{ &wdcdriver,   IO_WD1, IRQ14, -1, C 0x00000,     0, VEC(wdc0),   0, 0x0000, 0, 0 },
{ &fdcdriver,   IO_FD1,  IRQ6,  2, C 0x00000,     0, VEC(fdc0),   0, 0x0000, 0, 0 },
0
};

struct isa_device isa_devtab_tty[] = {
/*	driver	iobase	irq drq	maddr	msiz	intr unit	flags phys cnltr*/
{ & pcdriver,   IO_KBD,  IRQ1, -1, C 0x00000,     0, VEC(pc0),   0, 0x0000, 0, -1 },
0
};

struct isa_device isa_devtab_net[] = {
/*	driver	iobase	irq drq	maddr	msiz	intr unit	flags phys cnltr*/
{ & nedriver,	0x0320, IRQ10, -1, C 0x00000,     0, VEC(ne0),   0, 0x0000, 0, -1 },
0
};

struct isa_device isa_devtab_null[] = {
/*	driver	iobase	irq drq	maddr	msiz	intr unit	flags phys cnltr*/
{ &npxdriver,   IO_NPX, IRQ13, -1, C 0x00000,     0, VEC(npx0),   0, 0x0000, 0, -1 },
0
};

struct isa_device isa_subdev[] = {
/* driver       iobase    irq drq      maddr   msiz    intr unit flags phys */
{ &wdcdriver,        0,     0,  0, C 0x00000,     0,      0,   0, 0x00,   0, 0},
{ &wdcdriver,        0,     0,  0, C 0x00000,     0,      0,   1, 0x00,   1, 0},
{ &fdcdriver,        0,     0,  0, C 0x00000,     0,      0,   0, 0x00,   0, 0},
0
};

