/*
 * Copyright (c) 1982, 1986, 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	from: @(#)conf.c	7.3 (Berkeley) 5/5/91
 *	conf.c,v 1.2 1993/05/22 07:58:46 cgd Exp
 */

#include <sys/param.h>
#include "saio.h"

extern int	nullsys(), nodev(), noioctl();

#ifndef BOOT
int	ctstrategy(), ctopen(), ctclose();
#define	ctioctl	noioctl
#endif

int	rdstrategy(), rdopen();
#define	rdioctl	noioctl

int	sdstrategy(), sdopen();
#define	sdioctl	noioctl


struct devsw devsw[] = {
	{ "rd",	rdstrategy,	rdopen,	nullsys, noioctl },	/* 0 = rd */
	{ "sd",	sdstrategy,	sdopen,	nullsys, noioctl },	/* 1 = sd */
#ifndef BOOT
	{ "ct",	ctstrategy,	ctopen,	ctclose, noioctl },	/* 2 = ct */
#endif
	{ NULL },
};

int	ndevs = (sizeof(devsw)/sizeof(devsw[0]));
